define(['TrackersService'], function () {
    'use strict';

    describe('TrackersService', function () {
        var TrackersService,
            weightFHIRService,
            bpPulseFHIRService,
            moodFHIRService,
            cholesterolFHIRService,
            glucoseFHIRService,
            fitnessFHIRService,
            fitnessActivityFHIRService

        beforeEach(function () {
            module('angularTemplateApp');

            weightFHIRService = function () {
                this.type = 'Observation'
            };

            bpPulseFHIRService = function () {
                this.type = 'Observation'
            };

            moodFHIRService = function () {
                this.type = 'Observation';
            };
            cholesterolFHIRService = function () {
                this.type = 'Observation';
            };
            glucoseFHIRService = function(){
                this.type = 'Observation';
            };
            fitnessFHIRService = function(){
                this.type = 'Observation';
            };


            module(function ($provide) {
                $provide.value('WeightFHIRService', new weightFHIRService());
                $provide.value('BpPulseFHIRService', new bpPulseFHIRService());
                $provide.value('GlucoseFHIRService', new glucoseFHIRService());
                $provide.value('CholesterolFHIRService', new cholesterolFHIRService());
                $provide.value('MoodFHIRService', new moodFHIRService());
                $provide.value('FitnessActivityFHIRService', new fitnessActivityFHIRService());
            });

            inject(function (TrackersService) {
                TrackersService = TrackersService;
            });
        });

        it('should return a WeightFHIRService when the key is weight', function () {
            var service = TrackersService.instance('weight');

            expect(service instanceof weightFHIRService).toBeTruthy();
        });

        it('should return a BpPulseFHIRService when the key is bp-pulse', function () {
            var service = TrackersService.instance('bp-pulse');

            expect(service instanceof bpPulseFHIRService).toBeTruthy();
        });



        it('should return a GlucoseFHIRService when the key is glucose', function () {
            var service = TrackersService.instance('glucose');

            expect(service instanceof glucoseFHIRService).toBeTruthy();
        });

    });
});